<?php defined('SYSPATH') or die('No direct script access.');

class Model_Problem extends ORM
{
    
    protected $_table_columns = [
        'id' => null,
        'server' => null,
        'filename' => null,
        'logline' => null,
        'level' => null,
        'description' => null,
        'created_at' => null,
        'deleted_at' => null,
    ];
    
    public function scopeVisible()
    {
        $this->where('deleted_at', 'IS', null);
        
        return $this;
    }
    
    public function getLoglineFormatted()
    {
        $mapLevelToBootstrapClass = [
            0 => 'danger',
            1 => 'warning',
            2 => 'info',
        ];
        
        $level = $this->getAdjustedLevel();
        
        if (isset($mapLevelToBootstrapClass[$this->level])) {
            $bootstrapClass = 'text-' . $mapLevelToBootstrapClass[$this->level];
        } else {
            $bootstrapClass = '';
        }
        
        return '<span class="' . $bootstrapClass . '">' . $this->logline . '</span>';
    }
    
    protected function getAdjustedLevel()
    {
        // Each two days level is decreased by one
        return $this->level + floor((time() - strtotime($this->created_at)) / ( 2 * Date::DAY ));
    }

}

